<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Add order_id and order_item_id columns to supplier_receipts table
    $sql = "ALTER TABLE supplier_receipts 
            ADD COLUMN order_id INT NULL AFTER serial_numbers,
            ADD COLUMN order_item_id INT NULL AFTER order_id,
            ADD INDEX idx_order_id (order_id),
            ADD INDEX idx_order_item_id (order_item_id)";
    
    $pdo->exec($sql);
    echo "✅ Added order_id and order_item_id columns to supplier_receipts table!\n";
    
    // Add foreign keys if the tables exist
    try {
        $sql = "ALTER TABLE supplier_receipts 
                ADD CONSTRAINT fk_supplier_receipts_order_id 
                FOREIGN KEY (order_id) REFERENCES supplier_orders(id) ON DELETE SET NULL,
                ADD CONSTRAINT fk_supplier_receipts_order_item_id 
                FOREIGN KEY (order_item_id) REFERENCES supplier_order_items(id) ON DELETE SET NULL";
        
        $pdo->exec($sql);
        echo "✅ Added foreign key constraints to supplier_receipts table!\n";
    } catch (PDOException $e) {
        echo "⚠️  Foreign key constraints not added (tables may not exist): " . $e->getMessage() . "\n";
    }
    
} catch (PDOException $e) {
    echo "❌ Error adding columns to supplier_receipts table: " . $e->getMessage() . "\n";
    exit(1);
}

echo "🎉 Migration completed successfully!\n";
?> 